using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class ETL_ExtractBatch_LogDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public ETL_ExtractBatch_LogDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<ETL_ExtractBatch_Log> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<ETL_ExtractBatch_Log> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_ETL_ExtractBatch_Log_getitemsByRegistry", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReader(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<ETL_ExtractBatch_Log>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public ETL_ExtractBatch_Log ParseReader(DataRow row)
        {
            ETL_ExtractBatch_Log objReturn = new ETL_ExtractBatch_Log
            {
                CDW_Table_View_Name = (string)GetNullableObject(row.Field<object>("CDW_Table_View_Name")),
                CountFinal = (Int32?)GetNullableObject(row.Field<object>("CountFinal")),
                CountStage = (Int32?)GetNullableObject(row.Field<object>("CountStage")),
                ETL_Name = (string)GetNullableObject(row.Field<object>("ETL_Name")),
                ETL_StepName = (string)GetNullableObject(row.Field<object>("ETL_StepName")),
                ETLBatchID = (Int32?)GetNullableObject(row.Field<object>("ETLBatchID")),
                ExtractBatchID = (Int64?)GetNullableObject(row.Field<object>("ExtractBatchID")),
                ExtractDateTime = (DateTime?)GetNullableObject(row.Field<object>("ExtractDateTime")),
                ID = (Int32)GetNullableObject(row.Field<object>("ID")),
                Registry_ID = (Int32?)GetNullableObject(row.Field<object>("Registry_ID")),
                UserName = (string)GetNullableObject(row.Field<object>("UserName"))
            };

            return objReturn;
        }

        #endregion
    }
}
